#
# Gun class
# Bryan Clair 2011
#
from AudioPlayer import AudioPlayer
import wave
class Gun:
    """Emulate a six-shooter gun."""

    def __init__(self,capacity=6):
        """Create a gun with given capacity (default is 6)"""
        self._capacity = capacity
        self._shots = self._capacity
        self._soundplayer = AudioPlayer()
        self._bangsound = wave.open('bang.wav','rb')
        self._clicksound = wave.open('click.wav','rb')

    def fire(self):
        """Shoot a bullet, if the gun has any left."""
        if self._shots > 0:
            self._soundplayer.play(self._bangsound)
            self._bangsound.rewind()
            self._shots -= 1
        else:
            self._soundplayer.play(self._clicksound)
            self._clicksound.rewind()
 
    def reload(self):
        self._shots = self._capacity

if __name__ == '__main__':
	g = Gun(3)
	print 'You should hear: bang, bang, bang, click, bang'
	g.fire()
	g.fire()
	g.fire()
	g.fire()
	g.reload()
	g.fire()