/*
 * PoolMath.h
 *
 *    Utility mathematical functions.
 *
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef POOLMATH_H
#define POOLMATH_H

//
// Binomial coefficients
//   Values of C(n,k) for n=0,..,PM_MAX_BINOM and k=0,..,n
//
#define PM_MAX_BINOM 31
extern const double PM_binom[PM_MAX_BINOM+1][PM_MAX_BINOM+1];

//
// double rand_prob()
//   Generate a random number uniformly distributed in [0,1].
// 
double rand_prob(void);

//
// bump_rand
//   Give a random double in the range [a,b] with a bump distribution
//   (more likely to be in the middle of the range)
//
double bump_rand(double a, double b);

//
// distort_prob_bump
//   Randomly distort a probability.
//   Does a bump distribution centered on the current value
//   of p and with maximum possible width.
//
double distort_prob_bump(const double p);

//
// distort_prob_uniform
//   Randomly distort a probability.
//   Uniform on the interval [p - epsilon, p + epsilon] /\ [0,1]
//
double distort_prob_uniform(const double p, const double epsilon);

//
// pooltie
//
//   Computes        N+1   N+1
//              (x+e)  -  x           N      k    N-k
//    f(x,y) =  --------------  = sum   (x+e)  * x
//                    e             k=0
//
double pooltie(int N, double x, double e);

// pooltie_alt
//   Computes    N+1   N+1
//              x  -  y        N   k    N-k
//    f(x,y) =  -------  = sum    x  * y
//               x - y       k=0
//
double pooltie_alt(int N, double x, double y);

#endif
