/*
 * PoolMathBinomBuilder.C
 *
 *   Calculates a table of binomial coefficients and prints
 *   to stdout formatted as an array for inclusion into C
 *   programs.
 *
 *   Used to create PoolMathBinom.C during compilation.
 *
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include "PoolMath.h"

using namespace std;

main(int argc, char *argv[])
{
  if (PM_MAX_BINOM < 1) {
    printf("#error ""Failed to generate table of binomial coefficients""\n");
    exit(1);
  }

  printf("/*\n* This file generated automatically by PootMathBinomBuilder\n*/\n\n");

  int n,k;
  long binom_vals[PM_MAX_BINOM+1][PM_MAX_BINOM+1];

  printf("const double PM_binom[PM_MAX_BINOM+1][PM_MAX_BINOM+1] = \n");
  for (n = 0; n <= PM_MAX_BINOM; n++)
    for (k = 0; k <= n; k++) {
      if ((k == 0) || (k == n)) binom_vals[n][k] = 1;
      else binom_vals[n][k] = binom_vals[n-1][k-1] + binom_vals[n-1][k];
    }

  printf("{");
  for (n=0; n <= PM_MAX_BINOM; n++) {
    if (n > 0) printf(",\n");
    printf("{");
    for (k=0; k <= PM_MAX_BINOM; k++) {
      if (k > 0) printf(", ");
      if (k <= n) printf("%ld.",binom_vals[n][k]);
      else printf("FP_NAN");
    }
    printf("}");
  }
  printf("};\n");
}
