/*
 * TourneyH2H.h
 *
 *   Manages one matrix of head-to-head probabilities for a tournament.
 *
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef _TOURNEYH2H_H_
#define _TOURNEYH2H_H_

#include "TourneyBasics.h"

class Winround;

class HeadToHead {
 public:
  HeadToHead();                    // default constructor
  ~HeadToHead();                   // destructor
  HeadToHead(const HeadToHead&);   // copy constructor
  HeadToHead& operator=(const HeadToHead&); // assignment

  // constructor
  //        Pass # of teams
  HeadToHead(team_t);

  // constructor
  //        Pass # of teams and 2d array of head-to-head data
  HeadToHead(team_t, double *);

  // constructor
  //        From Winround data
  HeadToHead(const Winround&);

  // teams
  //        Return # of teams
  inline team_t teams(void) const { return numt; }

  // operator()
  //        Return head-to-head probability that team t1 beats team t2.
  double operator() (team_t t1, team_t t2) const;
  
  // set
  //        Set head-to-head probability for team t1 beating team t2.
  void set(team_t t1, team_t t2, double prob);

  // dump
  //        Dump data to stdout in a stream of floats.
  void dump() const;

  // display
  //        Display all data on stdout, nicely formatted, use teamnames if given.
  void display(char *teamnames[] = NULL) const;

 private:
  int numt;
  double *data;
};

#endif


