/*
 * TourneyPool.h
 *
 *   Manage data in a tournament pool.
 *
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef TOURNEYPOOL_H
#define TOURNEYPOOL_H

#include <istream>
#include <ostream>
#include <iostream>
#include <string>
#include <vector>

#include "TourneyPack.h"
#include "TourneyPicks.h"
#include "TourneyFile.h"
#include "Normal.h"

/*********************************************************************/
/*   TourneyPool                                                    */
/*********************************************************************/
/*
 */
class TourneyPool {
 public:
  TourneyPool();
  TourneyPool(const TourneyPool&);
  ~TourneyPool();
  TourneyPool& operator=(const TourneyPool&); // unimplemented

  // construct from ProbSuites
  TourneyPool(const ProbSuite& a, const ProbSuite& p);

  // title stuff
  std::string title() const { return mytitle; }
  void set_title(const std::string &s) { mytitle = s; }

  // team names
  void set_names(const Names&);

  team_t teams() const { return numt; }
  round_t rounds() const { return numr; }

  const ProbSuite& actual() const { return A; }
  const ProbSuite& perceived() const { return P; }

  // display_summary
  //    print a summary of TourneyPool contents to cout
  void display_summary() const;

  // display_picks
  //    print a Picks to cout using teamname data
  void display_picks(const Picks&) const;

  // display_opponent_stats
  //    cout stats about opponent scores
  void display_opponent_stats();

  // display_stats
  //    cout stats about picks (mean, sd, etc.)
  void display_stats(Picks);

  // smooth_expected
  //    Calculate the approximate expected return on picks in this pool,
  //    given number of opponents.
  double smooth_expected(int N, const Picks& picks,
			 Normal_integrator *nit = NULL);
  
 private:
  team_t numt;
  round_t numr;
  ProbSuite A, P;
  Names teamnames;
  std::string mytitle;

  // only calculate these stats once
  bool stats_calculated;
  double muX, sig2X, vXX;
};

#endif
