/*
 * dumpwinround.C
 *
 *   Dump winround data for a suite of probabilities
 *
 * usage: dumpwinround probfile
 *
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * 9/29/16 Fixing obsolete code so it will compile.
 */

#include <iostream>
#include <fstream>
#include <stdlib.h>
#include <unistd.h>

#include "TourneyPack.h"
#include "TourneyPool.h"
#include "TourneyFile.h"

using namespace std;

bool dump_pair=true;

//
// usage
//
void usage(char *msg=NULL) {
  cerr << "usage: dumpwinround [-p] probfile"
       << endl;
  if (msg) cerr << "       " << msg << endl;
  exit(1);
}

//
// main
//
main(int argc, char *argv[]) {
  // Parse arguments
  char opt;
  while ((opt = getopt(argc,argv,"p")) != -1)
    switch (opt) {
    case 'p':
      dump_pair = false;
      break;
    default:
      usage();
    }
  if (optind != argc-1) usage();

  ProbSuite *p;

  try {
    ifstream pf(argv[optind]);
    if (!pf) throw TP_read_error("couldn't open file");
    p = read_probfile(pf);
  } catch (TP_read_error& err) {
    err.display();
    exit(1);
  }

  // Print header
  cout << "winround " << p->teams() << ' ' << p->title() << endl;
  cout << "solo" << endl;
  p->winround().dump_solo();
  if (dump_pair) {
    cout << "pair" << endl;
    p->winround().dump_pair();
  }
}

