/*
 * fcanon.C
 *
 *    Calculate canonical picks for weekly data.
 *
 * usage: fcanon [-qfde] datafile [-Aactuals] [-Pperceiveds]
 *   -q  quiet.. show picks only
 *   -f  show actual favorites
 *   -d  show actual underdogs 
 *   -e  show edge picks
 *   -AP change column of data file
 *
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * 1/16/06 - Changed behavior to print possibly more than one set of picks.
 * 9/29/16 Fixing obsolete code so it will compile.
 */

#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <stdlib.h>
#include <unistd.h>

#include "FootballPack.h"
#include "FootballPool.h"

using namespace std;

//
// global pool
//
FootballPool pool;

//
// usage
//
void usage(char *msg=NULL) {
  cerr << " usage: fcanon [-qfde] datafile  [-Aactuals] [-Pperceiveds]\n"
       << "   -q  quiet.. just print picks\n"
       << "   -f  show actual favorites\n"
       << "   -d  show actual underdogs\n"
       << "   -e  show edge picks\n";
  if (msg) cerr << "       " << msg << endl;
  exit(1);
}

//
// default arguments
//
bool quiet = false;
bool favorites = false;
bool dogs = false;
bool edge = false;

//
// main
//
main(int argc, char *argv[]) {
  string atype = "", ptype = "";
  
  // Parse arguments
  char opt;
  while ((opt = getopt(argc,argv,"qfdeA:P:")) != -1)
    switch (opt) {
    case 'A':
      atype = optarg;
      break;
    case 'P':
      ptype = optarg;
      break;
    case 'q':
      quiet = true;
      break;
    case 'f':
      favorites = true;
      break;
    case 'd':
      dogs = true;
      break;
    case 'e':
      edge = true;
      break;
    default:
      usage();
    }
  if (optind != argc-1) usage();

  // Open file and read pool data
  char *datafilename = argv[optind];
  ifstream datafile(datafilename);
  if (!datafile) {
    perror(datafilename);
    exit(1);
  }

  try {
    pool.read(datafile,atype,ptype);
  } catch (FP_read_error& err) {
    err.display();
    exit(1);
  }

  // Print header
  if (!quiet) pool.write(cout);

  if (favorites) {
    if (!quiet) cout << "Favs:\t";
    pool.displayOutcome(pool.actual().favorites());
    cout << endl;
  }
  if (dogs) {
    if (!quiet) cout << "Dogs:\t";
    pool.displayOutcome(pool.actual().underdogs());
    cout << endl;
  }
  if (edge) {
    if (!quiet) cout << "Edge:\t";
    pool.displayOutcome(edge_picks(pool.actual(),pool.perceived()));
    cout << endl;
  }
}

