/*
 * pixdiff.C
 *
 *  Count round-by-round differences in two sets of picks.
 *  Picksets in depth format, back to back on stdin.  Must be 64 teams.
 *
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <iostream>
using namespace std;

main() {
  int a[64],b[64];
  int i;

  for (i=0; i<64; i++) {
    cin >> a[i];
    if (a[i] < 1 || a[i] > 7) {
      cout << "bad round number on input" << endl;
      exit(1);
    }
  }

  for (i=0; i<64; i++) {
    cin >> b[i];
    if (b[i] < 1 || b[i] > 7) {
      cout << "bad round number on input" << endl;
      exit(1);
    }
  }

  for (int r = 1; r < 7; r++) {
    int count=0;
    for (i=0; i<64; i++) {
      if (a[i] > r && b[i] <= r) count++;
    }
    cout << "round " << r << " has " << count << " differences.\n";
  }
}


  
