/*
 * tcanon.C
 *
 *   Show winround data and canonical picks for a suite of probabilities
 *
 * usage: tcanon [-qE] namesfile actualfile perceivedfile
 *   -q  quiet
 *   -E  use ESPN worth
 *
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * 9/29/16 Fixing obsolete code so it will compile.
 */

#include <iostream>
#include <sstream>
#include <stdlib.h>
#include <unistd.h>

#include "TourneyPack.h"
#include "TourneyPool.h"
#include "TourneyFile.h"

using namespace std;

//
// usage
//
void usage(char *msg=NULL) {
  cerr << "usage: tcanon [-qE] namesfile actualfile perceivedfile"
       << endl;
  if (msg) cerr << "       " << msg << endl;
  exit(1);
}

//
// global pool
//
TourneyPool *pool;

//
// default arguments
//
bool quiet = false;

//
// main
//
main(int argc, char *argv[]) {
  // Parse arguments

  char opt;
  while ((opt = getopt(argc,argv,"qE")) != -1)
    switch (opt) {
    case 'q':
      quiet = true;
      break;
    case 'E':
      worth_function_set(worth_ESPN);
      break;
    default:
      usage();
    }
  if (optind != argc-3) usage();

  try {
    pool = read_pool(argv+optind);
  } catch (TP_read_error& err) {
    err.display();
    exit(1);
  }

  // Print header
  if (!quiet) {
    pool->display_summary();
    pool->display_opponent_stats();
  }

  cout << "Maxex for a:\t";
  write_depth(pool->actual().max_expected_score());
  cout << endl;
  
  cout << "Favs for a:\t";
  write_depth(pool->actual().favorites());
  cout << endl;

  cout << "Favs for p:\t";
  write_depth(pool->perceived().favorites());
  cout << endl;

  cout << "Likely for a:\t";
  write_depth(pool->actual().most_likely());
  cout << endl;

  cout << "Likely for p:\t";
  write_depth(pool->perceived().most_likely());
  cout << endl;

  cout << "Limit for a,p:\t";
  write_depth(best_for_large_pool(pool->actual(),pool->perceived()));
  cout << endl;
}

