/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * StatTest
 *
 *   Classes for running quick and dirty checks of
 *   calculated statistics.
 */

#ifndef STATTEST_H
#define STATTEST_H

/**************************************************/
/* Trials Class                                   */
/**************************************************/
//
// Calculate mean, variance, and S.D. for sample data.
// Call add_point repeatedly to add data points.
// Automatically prints results every now and then.
//
class Trials {
 public:
  // Begin trials and display header
  Trials(); 
  Trials(double cmean, double cvar); // show computed values at start

  // Add one more data point (might display())
  void add_point(double x);

  // Display current stats
  void display() const;

  // How many data points so far?
  unsigned long num_trials(void) const { return num; }

 private:
  unsigned long num;
  double mean;
  double sumsq;
  time_t last;
};

/**************************************************/
/* CoTrials Class                                 */
/**************************************************/
//
// Calculate mean, variance, and S.D. for each of two
// streams of sample data, and calculate the covariance.
// Call add_point repeatedly to add data points.
// Automatically prints results every now and then.
//
class CoTrials {
 public:
  // Begin trials and display header
  CoTrials();
  CoTrials(double cmean1, double cvar1,
	   double cmean2, double cvar2,
	   double ccovar); // show computed values at start

  // Add one more data point (might display())
  void add_point(double x, double y);

  // Display current stats
  void display() const;

  // How many data points so far?
  unsigned long num_trials(void) const { return num; }

 private:
  unsigned long num;
  double meanx, meany;
  double sumxsq, sumysq;
  double sumxy;
  time_t last;
};

#endif
