/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * TourneyApp
 *
 *   Support for simple test applications using the TourneyPack package
 */

#include <iostream>
#include <unistd.h>
#include "PoolMath.h"
#include "TourneyBasics.h"
#include "TourneyApp.h"

using namespace std;

/**************************************************/
/* TourneyApp_initialize                          */
/**************************************************/
//
// Parse arguements and ask for # of rounds, if necc.
//   Seeds the random # generator.
//   Returns # of rounds.
//
round_t TourneyApp_initialize(int argc, char *argv[]) {
  round_t rounds = 0;
  long seed = time(NULL);

  //
  // Parse arguments
  //
  char option;
  while ((option = getopt(argc,argv,"s:r:")) != EOF) {
    switch (option) {
    case 'r':
      rounds = atoi(optarg);
      break;
    case 's':
      seed = atol(optarg);
      break;
    case '?':
    default:
      cerr << "usage: " << argv[0] << " [-s seed] [-r rounds]\n";
      exit(1);
    }
  }

  if (rounds == 0) {
    cout << "Rounds? ";
    cin >> rounds;
  }
  if ((rounds < 1) || (rounds>MAX_ROUNDS)) {
    cerr << "usage: rounds must be 1.." << MAX_ROUNDS << ".\n";
    exit(1);
  }

  srandom(seed);

  return rounds;
}


// PS_random
//
//   Create a ProbSuite with R rounds and random entries
ProbSuite PS_random(round_t R) {
  team_t T = teams_from_rounds(R);

  double data[T][T];

  for (int i = 0; i < T; i++) {
    for (int j = 0; j < i; j++) {
      data[i][j] = rand_prob();
      data[j][i] = 1 - data[i][j];
    }
  }

  return ProbSuite(T,&data[0][0]);
}

