/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * TourneyApp
 *
 *   Support for simple test applications using the TourneyPack package
 */

#ifndef TOURNEYAPP_H
#define TOURNEYAPP_H

#include "TourneyBasics.h"
#include "TourneyPack.h"

// TourneyApp_initialize
//
// Parse arguements and ask for # of rounds, if necc.
//   Seeds the random # generator.
//   Returns # of rounds.
//
round_t TourneyApp_initialize(int argc, char *argv[]);

// PS_random
//
//   Create a ProbSuite with R rounds and random entries
ProbSuite PS_random(round_t);

#endif
