/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * covar_experiment.C
 *
 *  See how covariance depends on strategy.
 */

#include <iostream>
#include "TourneyPack.h"
#include "TourneyApp.h"
#include "StatTest.h"

using namespace std;

main(int argc, char *argv[])
{
  //
  // Parse arguments
  //
  round_t R = TourneyApp_initialize(argc,argv);

  cout << "\nTEST COVARIANCE FOR VARIOUS STRATEGIES\n";

  ProbSuite a = PS_random(R);
  ProbSuite p = PS_random(R);

  // A set of better perceiveds:
  ProbSuite pa = a.random_variation();

  Picks favs = a.favorites();

  //
  // Make predictions
  //
  double var;
  cout << "\nMax score possible:" << endl;
  cout << worth_max(R) << endl;
  cout << "\nPredicted MEAN for bet on FAVORITES:" << endl;
  cout << mean(a,favs) << endl;
  cout << "\nPredicted VARIANCE for bet on FAVORITES:" << endl;
  cout << (var=variance(a,favs)) << endl;
  cout << "\nPredicted S.D. for bet on FAVORITES:" << endl;
  cout << sqrt(var) << endl;
  cout << "\nPredicted MEAN for BETTER perceived:" << endl;
  cout << mean(a,pa) << endl;
  cout << "\nPredicted VARIANCE for BETTER perceived:" << endl;
  cout << (var=variance(a,pa)) << endl;
  cout << "\nPredicted S.D. for BETTER perceived:" << endl;
  cout << sqrt(var) << endl;
  cout << "\nPredicted MEAN for RANDOM perceived:" << endl;
  cout << mean(a,p) << endl;
  cout << "\nPredicted VARIANCE for RANDOM perceived:" << endl;
  cout << (var=variance(a,p)) << endl;
  cout << "\nPredicted S.D. for RANDOM perceived:" << endl;
  cout << sqrt(var) << endl;

  cout << endl << endl;
  cout << "Covariances:\n";
  cout << "  v(favs,favs) = " << covariance(a,favs,favs) << endl;
  cout << "  v(favs,good) = " << covariance(a,pa,favs) << endl;
  cout << "  v(favs,opp)  = " << covariance(a,p,favs) << endl;
  cout << "  v(good,good) = " << covariance(a,pa,pa) << endl;
  cout << "  v(good,opp) = " << covariance(a,pa,p) << endl;
  cout << "  v(opp,opp)   = " << covariance(a,p,p) << endl;

  cout << "Many trials of v(favs,opp) for different random percieved:\n" << endl;

  Trials data;
  while(1) {
    ProbSuite q(R,PS_random);
    data.add_point(covariance(a,q,favs));
  }
}


