/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * covartest2.C
 *
 *  Test calculations of covariance between fixed bet and
 *  opponent.
 */

#include <iostream>
#include "TourneyPack.h"
#include "TourneyApp.h"
#include "StatTest.h"

using namespace std;

main(int argc, char *argv[])
{
  //
  // Parse arguments
  //
  round_t R = TourneyApp_initialize(argc,argv);

  cout << "\nTEST COVARIANCE FOR FIXED BET AND OPPONENT\n";

  //
  // A set of actual probabilites
  //
  ProbSuite a = PS_random(R);

  //
  // A set of perceived probabilites
  //
  ProbSuite p = PS_random(R);

  Picks favs = a.favorites();

  //
  // Make predictions
  //
  double var;
  cout << "\nMax score possible:" << endl;
  cout << worth_max(R) << endl;
  cout << "\nPredicted MEAN for bet on FAVORITES:" << endl;
  cout << mean(a,favs) << endl;
  cout << "\nPredicted VARIANCE for bet on FAVORITES:" << endl;
  cout << (var=variance(a,favs)) << endl;
  cout << "\nPredicted S.D. for bet on FAVORITES:" << endl;
  cout << sqrt(var) << endl;
  cout << "\nPredicted MEAN for RANDOM BET with perceived:" << endl;
  cout << mean(a,p) << endl;
  cout << "\nPredicted VARIANCE for RANDOM BET with perceived:" << endl;
  cout << (var=variance(a,p)) << endl;
  cout << "\nPredicted S.D. for RANDOM BET with perceived:" << endl;
  cout << sqrt(var) << endl;
  cout << "\nPredicted COVARIANCE between FAVORITES and RANDOM BET:" << endl;
  cout << covariance(a,p,favs) << endl;

  //
  // Try it
  //
  CoTrials data;
  while(1) {
    Picks result = a.random_picks();
    data.add_point(score(result,favs), score(result,p.random_picks()));
  }
}


