/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * fb_varbet.C
 *   Test calculation of mean & variance for varying picks.
 */
#include <iostream>
#include <unistd.h>

#include "PoolMath.h"
#include "FootballPack.h"
#include "StatTest.h"

using namespace std;

main(int argc, char *argv[]) {
  int g;
  if (argc != 2 || (g = atoi(argv[1])) <= 0)
    cerr << "usage: " << argv[0] << " <games>" << endl;

  srandom(time(NULL));

  cout << "Stats for fixed pick probs, fixed actual probs." << endl;

  double ra[g];
  for (int i=0; i<g; i++)
    ra[i] = rand_prob();

  ProbVec a(g,ra);

  cout << "Actual probs:" << endl;
  a.display();
  cout << endl;

  for (int i=0; i<g; i++)
    ra[i] = rand_prob();

  ProbVec p(g,ra);

  cout << "Perceived probs:" << endl;
  p.display();
  cout << endl;

  Trials t(mean(a,p),variance(a,p));

  Outcome r,s;
  while (1) {
    r = a.random_picks();
    s = p.random_picks();
    t.add_point(scoreOutcome(r,s,g));
  }

}
