/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * h2h_winround.C
 *   Test conversion of h2h to winround and back.
 */

#include <iostream>
#include "PoolMath.h"
#include "TourneyBasics.h"
#include "TourneyPack.h"
#include "TourneyApp.h"
#include "StatTest.h"

using namespace std;

main(int argc, char *argv[])
{
  round_t R = TourneyApp_initialize(argc,argv);

  team_t T = teams_from_rounds(R);

  double data[T][T];

  for (int i = 0; i < T; i++) {
    for (int j = 0; j < i; j++) {
      data[i][j] = rand_prob();
      data[j][i] = 1 - data[i][j];
    }
  }

  
  HeadToHead hh(T,&data[0][0]);
  cout << "Original h2h data: " << endl;
  hh.display();

  Winround ww(hh);
  HeadToHead hhclone(ww);

  cout << "After converting to Winround and back: " << endl;
  hhclone.display();
}


