/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * pickbyluck.C
 *
 *   Creates random tournament, random picks.
 *   Finds the score, repeats.
 */

#include <iostream>
#include "TourneyPack.h"
#include "TourneyApp.h"
#include "StatTest.h"

using namespace std;

main(int argc, char *argv[])
{
  //
  // Parse arguments
  //
  round_t R = TourneyApp_initialize(argc,argv);

  //
  // Main experiment
  //
  cout << "Random poolsheets in random tournaments with " << R << " rounds.\n";
  cout << "(Mean value is " << mean_for_random_picks(R) << ")\n\n";

  Trials data;

  while (1) {
    ProbSuite a = PS_random(R), p = PS_random(R);
    data.add_point(score(a.random_picks(),p.random_picks()));
  }
}


