/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * strategies
 *
 *   Compare the mean value of various strategies for picking
 *   in a fixed tournament.
 */

#include <iostream>
#include "TourneyPack.h"
#include "TourneyApp.h"
#include "StatTest.h"

using namespace std;

main(int argc, char *argv[])
{
  //
  // Parse arguments
  //
  round_t R = TourneyApp_initialize(argc,argv);

  //
  // A set of actual probabilites
  //
  ProbSuite a = PS_random(R);

  cout << "ACTUAL probabilities - random." << endl;

  Picks favs = a.favorites();
  cout << "\nFAVORITES:" << endl;
  favs.display();

  Picks likely = a.most_likely();
  cout << "\nMOST LIKELY TO OCCUR:" << endl;
  likely.display();

  //
  // Calculate mean values
  //
  cout << "\nMEAN VALUES: " << endl;
  cout << "\trandom picks       : " << mean_for_random_picks(R) << endl;
  cout << "\tperceieved = actual: " << mean(a,a) << endl;
  cout << "\tfavorites          : " << mean(a,favs) << endl;
  cout << "\tmost likely        : " << mean(a,likely) << endl;
}


