/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * ttest.C
 *
 *  Simple tests for TourneyPack package
 */

#include <iostream>
#include "TourneyPack.h"
#include "TourneyFile.h"
#include "TourneyApp.h"
#include "StatTest.h"

using namespace std;

main(int argc, char *argv[])
{
  //
  // Parse arguments
  //
  round_t R = TourneyApp_initialize(argc,argv);

  //
  // A set of actual probabilites
  //
  //  ProbSuite a0(R,PS_NCAA_seed_history);
  //  ProbSuite a = a0.random_variation();
  ProbSuite a = PS_random(R);
  cout << "ACTUAL VALUES (random)" << endl;
  a.display();

  // Some perceptions
  //
  ProbSuite p = PS_random(R);
  cout << "PERCEIVED VALUES (random)" << endl;
  p.display();

  //
  // Some interesting picks
  //
  Picks favs = a.favorites();
  cout << "\nFAVORITES:" << endl;
  favs.display();

  double ret;
  Picks likely = a.most_likely(&ret);
  cout << "\nLIKELY:" << endl;
  cout << "(with probability " << ret << ")" << endl;
  likely.display();
  
  Picks maxex = a.max_expected_score(&ret);
  cout << "\nMAX EXPECTED SCORE:" << endl;
  cout << "(with expected score " << ret << ")\n";
  maxex.display();

  Picks limit = best_for_large_pool(a,p,&ret);
  cout << "\nBEST PICKS IN A VERY LARGE POOL:" << endl;
  cout << "(with an expected return of " << ret << " on a bet of 1)\n";
  limit.display();
  
  Picks guess = p.random_picks();
  cout << "\nA RANDOM GUESS USING THESE PERCEIVED VALUES:" << endl;
  guess.display();

  //
  // General info about rounds & worth
  //
  cout << "\nROUNDS ARE WORTH: " << worth(1);
  for (round_t k = 2; k <= R; k++) cout << ", " << worth(k);
  cout << endl;
  cout << "MAX SCORE POSSIBLE: " << worth_max(R) << endl;
  cout << "MEAN FOR RANDOM PICKS: " << mean_for_random_picks(R) << endl;

  cout << "\nPROBABILITIES OF HAPPENING 100%:" << endl;
  cout << "maxexp:" << probability(a,maxex) << endl;
  cout << "favs  :" << probability(a,favs) << endl;
  cout << "likely:" << probability(a,likely) << endl;
  cout << "guess :" << probability(a,guess) << endl;
  cout << "limit :" << probability(a,limit) << endl;

  cout << "\nEXPECTED SCORE:" << endl;
  cout << "maxexp:" << mean(a,maxex) << endl;
  cout << "favs  :" << mean(a,favs) << endl;
  cout << "likely:" << mean(a,likely) << endl;
  cout << "guess :" << mean(a,guess) << endl;
  cout << "limit :" << mean(a,limit) << endl;

  cout << "\nSCORES FOR A SERIES OF RESULTS: " << endl;
  //
  // Play the games!
  //
  cout << "maxexp\tfavs\tlikely\tguess\tlimit\n";
  for (int x=0; x < 20; x++) {
    Picks results = a.random_picks();
    cout << score(results,maxex) << "\t";
    cout << score(results,favs) << "\t";
    cout << score(results,likely) << "\t";
    cout << score(results,guess) << "\t";
    cout << score(results,limit) << "\n";
  }
}


