/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * var_experiment
 *
 *   See how changes in h2h data affect the variance
 */

#include <iostream>
#include "TourneyPack.h"
#include "TourneyApp.h"
#include "StatTest.h"

using namespace std;

main(int argc, char *argv[])
{
  long start;
  //
  // Parse arguments
  //
  round_t R = TourneyApp_initialize(argc,argv);

  cout << R << " rounds, " << worth_max(R) << " possible points.\n";
  cout << "Displayed data are the variances from possible actual & perceived data\n";
  cout << "-----------------------------------------------------------\n";
  cout << "Experiment 1: Fixed random actual, varying random perceived.\n";
  ProbSuite a = PS_random(R);

  start = time(NULL);
  Trials ex1;
  do {
    ProbSuite p = PS_random(R);
    ex1.add_point(variance(a,p));
  } while (time(NULL) < start + 10);
  ex1.display();

  cout << "-----------------------------------------------------------\n";
  cout << "Experiment 2: Fixed random actual, varying perceived near actual.\n";
  cout << "Here the variance of p=a is " << variance(a,a) << endl;
  Trials ex2;
  start = time(NULL);
  do {
    ProbSuite p = a.random_variation();
    ex2.add_point(variance(a,p));
  } while (time(NULL) < start + 10);
  ex2.display();

  cout << "-----------------------------------------------------------\n";
  cout << "Experiment 3: NCAA seed actual NOT!, varying perceived near actual.\n";
  ProbSuite ancaa(R,PS_NCAA_seed_history);
  cout << "Here the variance of p=a is " << variance(ancaa,ancaa) << endl;
  Trials ex3;
  start = time(NULL);
  do {
    ProbSuite p = ancaa.random_variation();
    ex3.add_point(variance(ancaa,p));
  } while (time(NULL) < start + 10);
  ex3.display();


}


