/*
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 * Example of a tournament where knowing how teams advance
 * thorough rounds does not determine the variance.
 *
 * 4 teams, with actual probs. 0 or 1 to force team 0 and team 2
 *   to meet in the final, team 0 winning.
 *
 * Perceived probs. give 1/2 chance of winning round 1, and 1/4 chance
 * of winning round 2 to everyone.  But, 0 beats 2 with prob. x.
 */

#include <iostream>

#include "TourneyPack.h"
using namespace std;

main() {
  srandom(time(NULL));

  double actual[4][4] = {{.5,1,1,1},{0,.5,1,1},{0,0,.5,1},{0,0,0,.5}};
  //  double actual[4][4] = {{.5,.5,.5,.5},{.5,.5,.5,.5},{.5,.5,.5,.5},{.5,.5,.5,.5}};
  ProbSuite A(2,&actual[0][0]);
  // ProbSuite A(2,PS_random);
  A.display();

  double x;
  for (int i = 0; i <= 16; i++) {
    x = i/(double)16;
    double perc[4][4] = {{.5,.5,x,1-x},{.5,.5,1-x,x},{1-x,x,.5,.5},{x,1-x,.5,.5}};
    ProbSuite P(2,&perc[0][0]);
    cout << x << "\t: " << variance(A,P) << endl;
  }
}
