/*
 * trandom.C
 *
 *   Generate random sets of tournament picks in depth format
 *
 * usage: trandom [-n<number>] [-R<rounds>] [datafile]
 *
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * 9/29/16 Fixing obsolete code so it will compile.
 */

#include <iostream>
#include <fstream>
#include <stdlib.h>
#include <unistd.h>

#include "TourneyPicks.h"
#include "TourneyFile.h"

using namespace std;

//
// usage
//
void usage(const char *msg=NULL) {
  cerr << "usage: trandom [-n<number>] [-R<rounds>] [datafile]" << endl;
  if (msg) cerr << "       " << msg << endl;
  exit(1);
}

//
// default arguments
//
int numsets = 1;
round_t rounds = 6;

//
// main
//
main(int argc, char *argv[]) {
  // Parse arguments

  char opt;
  while ((opt = getopt(argc,argv,"n:R:")) != -1)
    switch (opt) {
    case 'n':
      numsets = atoi(optarg);
      break;
    case 'R':
      rounds = atoi(optarg);
      break;
    default:
      usage();
    }
  if ((rounds < 1) || (rounds > MAX_ROUNDS)) usage("bad # of rounds");

  srandom(time(NULL));

  if (optind == argc) {
    // no data - purely random picks
    while (numsets--) {
      write_depth(random_picks(rounds),cout);
      cout << endl;
    }
  } else if (optind == argc-1) {
    ProbSuite *data;
    try {
      ifstream df(argv[optind]);
      if (!df) throw TP_read_error("couldn't open actual file");
      data = read_probfile(df);
    } catch (TP_read_error& err) {
      err.display();
      exit(1);
    }
    while (numsets--) {
      write_depth(data->random_picks(),cout);
      cout << endl;
    }
  } else {
    usage();
  }
}

