/*
 * tscore.C
 *
 *   Calculate scores for one set of picks against another.
 *
 * usage: tscore [-E] [-r rounds] outcome
 *   -E  use ESPN worth
 *
 * Copyright (C) 2005 Bryan Clair
 *
 * This file is part of CLOP.
 *
 * CLOP is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * CLOP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CLOP; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * 9/29/16 Fixing obsolete code so it will compile.
 */

#include <iostream>
#include <sstream>
#include <fstream>
#include <stdlib.h>
#include <unistd.h>

#include "TourneyPack.h"
#include "TourneyFile.h"

using namespace std;

int rounds = 6;

Picks outcome;

//
// usage
//
void usage(const char *msg=NULL) {
  cerr << "usage: tscore [-E] [-r rounds] outcome"
       << "    Calculate scores for one set of picks against another."
       << endl;
  if (msg) cerr << "       " << msg << endl;
  exit(1);
}

//
// one set of picks
//
void do_one_set(char *line) {
  Picks X(rounds);
  istringstream s(line);
  try {
    read_depth(X,s);
  } catch (TP_read_error& err) {
    err.display();
    return;
  }
  
  cout << score(X,outcome) << '\t';
  write_depth(X);
  cout << endl;
}

//
// main
//
main(int argc, char *argv[]) {
  // Parse arguments

  char opt;
  while ((opt = getopt(argc,argv,"Er:")) != -1)
    switch (opt) {
    case 'E':
      worth_function_set(worth_ESPN);
      break;
    case 'r':
      rounds = atoi(optarg);
      break;
    default:
      usage();
    }
  if ((rounds < 1) || (rounds > MAX_ROUNDS)) usage("bad rounds");
  if (optind != argc-1) usage();

  fstream ofile(argv[optind]);
  if (!ofile) usage("failed to open outcome file");

  Picks oc(rounds);
  try {
    read_depth(oc,ofile);
  } catch (TP_read_error& err) {
    err.display();
    exit(1);
  }
  
  outcome = oc;

  char line[256];
  while(cin.getline(line,256)) {
    do_one_set(line);
  }
}
