import search
import sys
from time import time
from random import randrange

K = 1000   # number of distinct values within the experiment


def generate(n,k):
    """Return sorted list of n randomly chosen integers in range(k) for small k, 
    and a list of the corresponding frequency counts."""
    counts = [0] * k
    for _ in range(n):
        counts[randrange(k)] += 1
    data = []
    for j in range(k):
        for _ in range(counts[j]):
            data.append(j)
    return data,counts


def test(data, counts, func):
    print('  %15s...' % func.__name__, end='')
    sys.stdout.flush()
    success = True
    starttime = time()
    for j in range(K):
        if func(data, j, j) != counts[j]:
            success = False
        if j < K-1 and func(data, j, j+1) != counts[j]+counts[j+1]:
            success = False
    endtime = time()
    print('  %7s (time %3.8f)' % ('SUCCESS' if success else 'FAILURE', (endtime-starttime)))


for j in range(1,8):
    N = 10**j
    prettyN = str(N)
    group = []
    for k in range(1+(len(prettyN)-1)//3):
        group.append(prettyN[-3*(1+k):len(prettyN)-3*k])
    group.reverse()
    prettyN = ','.join(group)
    print('Testing with N=%s' % prettyN)
    print('Generating input...', end='')
    sys.stdout.flush()
    data,counts = generate(N,K)
    print('done')
    for f in vars(search):
        if f.startswith('count'):
            f = getattr(search,f)
            if callable(f):
                test(data, counts, f)
