# script to allow you to manually test matrix manipulations
#
# (no need to read this source code)
import re
import copyMatrix
from point import Point

DEFAULT_ROWS = 2
DEFAULT_COLS = 3

labels = sorted([elem for elem in dir(copyMatrix) if callable(getattr(copyMatrix,elem))])
copyfunc = [getattr(copyMatrix,f) for f in labels]

prompt = """Commands:
M) mutate an existing point instance
O) overwrite an entry with a new point instance
R) add new row to a matrix
C) add new column to a matrix
S) start over
Q) quit
"""

options = 'MORCSQ'

def initialize():
    global dirty
    dirty = False
    tables = []
    model = [ [Point(r,c) for c in range(DEFAULT_COLS)] for r in range(DEFAULT_ROWS)]
    tables.append(model)
    for f in copyfunc:
        tables.append(f(model))
    return tables

def display(m):
    for row in m:
        for val in row:
            print('  %7s' % (str(val)), end='')
        print()

def displayAll():
    print(('modified ' if dirty else '') + 'original:')
    display(tables[0])
    print()
    for k in range(1,len(tables)):
        print('%s(original):' % labels[k-1])
        display(tables[k])
        print()

def addRow(m):
    k = len(m[0])
    r = len(m)
    m.append([Point(r,c) for c in range(k)])

def addColumn(m):
    c = len(m[0])
    for r in range(len(m)):
        m[r].append(Point(r,c))

def getInt(prompt, small, large):
    result = small-1
    while not small <= result <= large:
        try:
            result = int(input(prompt))
            if not small <= result <= large:
                print("Value must be in range %s to %s" % (small,large))
        except ValueError:
            print("Please enter a valid number")
    return result


tables = initialize()
displayAll()
print()
print(prompt)

done = False
while not done:
    cmd = input("Enter command: ").upper()
    if len(cmd) != 1 or cmd not in options:
        print("Please select a valid command")
        print(prompt)
    elif cmd == 'Q':
        print("Goodbye")
        done = True
    else:
        if cmd == 'S':
            tables = initialize()
        elif cmd == 'R':
            addRow(tables[0])
            dirty = True
        elif cmd == 'C':
            addColumn(tables[0])
            dirty = True
        else:    # must want to mutate/overwrite a value
            dirty = True
            r = getInt("Which row? ", 0, len(tables[0]))
            c = getInt("Which column? ", 0, len(tables[0][r]))
            x = getInt("New x? ", 0, 99)
            y = getInt("New y? ", 0, 99)
            if cmd == 'M':
                tables[0][r][c].setX(x)
                tables[0][r][c].setY(y)
            else:    # cmd = 'O'
                tables[0][r][c] = Point(x,y)

        displayAll()
