import random
import search
import debug
from string import ascii_uppercase as UPPER

debug.activateDebug()
    
N = 20

functions = []
for f in vars(search):
    if f.startswith('count'):
        f = getattr(search,f)
        if callable(f):
            functions.append(f)

print("Performing manual test")
random.seed(0)
data = sorted(random.choice(UPPER) for _ in range(N))
print("      k: " + ' '.join('%2d'%k for k in range(N)))
print("data[k]: " + ' '.join('%2s'%data[k] for k in range(N)))

while True:
    print()
    low = input("Enter one-character low target:  ").upper()
    high =input("Enter one-character high target: ").upper()
    for f in functions:
        print()
        print('Calling %s(data, %s, %s)' % (f.__name__, low, high))
        ans = f(data,low,high)
        print('%s(data, %s, %s) returned %s' % (f.__name__, low, high, ans))
